/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import java.io.IOException;

import javax.jcr.RepositoryException;

/**
 * <code>VaultFileSystem</code>...
 */
public interface VaultFileSystem {

    /**
     * Releases all resources attached to this Vault filesystem
     * @throws RepositoryException if an error occurs.
     */
    void unmount() throws RepositoryException;

    /**
     * Checks if this tree is still mounted and if the attached session
     * is still live.
     *
     * @return <code>true</code> if still mounted
     */
    boolean isMounted();

    /**
     * Returns the root file
     * @return the root file
     */
    VaultFile getRoot();

    /**
     * Returns the attached artifacts manager.
     * @return the attached artifacts manager.
     */
    AggregateManager getAggregateManager();

    /**
     * Returns the file at the given path. If the file does not exists
     * <code>null</code> is thrown.
     *
     * @param path the path of the file
     * @return the file or <code>null</code>
     * @throws IOException if an I/O error occurs.
     * @throws RepositoryException if a repository error occurs.
     */
    VaultFile getFile(String path) throws IOException, RepositoryException;

    /**
     * Returns the file at the given path. The path can be relative and may
     * contain ".." path elements. If the file does not exists <code>null</code>
     * is returned.
     *
     * @param parent the parent file.
     * @param path the path of the file
     * @return the file or <code>null</code>
     * @throws IOException if an I/O error occurs.
     * @throws RepositoryException if a repository error occurs.
     */
    VaultFile getFile(VaultFile parent, String path)
            throws IOException, RepositoryException;

    /**
     * Starts a new transaction.
     * @return a new transaction.
     */
    VaultFsTransaction startTransaction();

    /**
     * Flushes the file cache
     * @throws RepositoryException if an error occurs
     */
    void invalidate() throws RepositoryException;

    /**
     * Returns the vault configuration that is used
     * @return the vault configuration.
     */
    VaultFsConfig getConfig();

    /**
     * Returns the current workspace filter
     * @return the workspace filter
     */
    WorkspaceFilter getWorkspaceFilter();

    
}