/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import java.io.IOException;
import java.util.Collection;

import javax.jcr.RepositoryException;

/**
 * <code>VaultFsTransaction</code>...
 */
public interface VaultFsTransaction {

    boolean isVerbose();

    void setVerbose(boolean verbose);

    void delete(VaultFile file) throws IOException;

    void modify(VaultFile file, VaultInputSource input) throws IOException;

    VaultFileOutput add(String path, VaultInputSource input)
        throws IOException, RepositoryException;

    void mkdir(String path) throws IOException, RepositoryException;

    /**
     * Commits the transaction and uploads all modifications to the repository.
     *
     * @return a list of modifications
     * @throws IOException if an I/O error occurs
     * @throws RepositoryException if a repository error occurs
     */
    Collection<Info> commit() throws RepositoryException, IOException;

    public enum Type {
        ADDED, ADDED_X, DELETED, MODIFIED, MOVED, MKDIR, ERROR
    }

    /**
     * the transaction info
     */
    public static class Info {

        private final Type type;

        private String path;

        public Info(Type type, String path) {
            this.type = type;
            this.path = path;
        }

        public String getPath() {
            return path;
        }

        public Type getType() {
            return type;
        }

    }
}