/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.api;

import java.io.InputStream;
import java.io.Reader;

import org.xml.sax.InputSource;

/**
 * Extends the {@link InputSource} by a content length and last modified.
 *
 */
public abstract class VaultInputSource extends InputSource {

    protected VaultInputSource() {
    }

    protected VaultInputSource(String systemId) {
        super(systemId);
    }

    protected VaultInputSource(InputStream byteStream) {
        super(byteStream);
    }

    protected VaultInputSource(Reader characterStream) {
        super(characterStream);
    }

    /**
     * Returns the content length of the underlying file.
     * @return the content length of the underlying file or -1 if unknown.
     */
    public abstract long getContentLength();

    /**
     * Returns the last modified date of the underlying file.
     * @return the last modified date of the underlying file or 0 if unknown.
     */
    public abstract long getLastModified();


}