/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <code>VaultUserConfig</code>...
 *
 */
abstract public class AbstractConfig {

    protected static Logger log = LoggerFactory.getLogger(AbstractConfig.class);

    public static final String DIR_NAME = ".vault";

    public static final String ATTR_VERSION = "version";

    private final org.apache.jackrabbit.vault.fs.config.AbstractConfig config;

    protected AbstractConfig(org.apache.jackrabbit.vault.fs.config.AbstractConfig config) {
        this.config = config;
    }

    public boolean load(File configFile) throws IOException, org.apache.jackrabbit.vault.fs.config.ConfigurationException {
        return config.load(configFile);
    }

    public File getConfigDir() throws IOException {
        return config.getConfigDir();
    }

    public void save(OutputStream out) throws IOException {
        config.save(out);
    }

    public boolean load(InputStream in) throws IOException, org.apache.jackrabbit.vault.fs.config.ConfigurationException {
        return config.load(in);
    }

    public void save(File configFile) throws IOException {
        config.save(configFile);
    }
}