/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import com.day.jcr.vault.fs.api.VaultFsConfig;
import com.day.jcr.vault.fs.impl.JrVltVaultFsConfigAdapter;

/**
 * <code>JcrFsConfig</code>...
 */
public abstract class AbstractVaultFsConfig {

    public static VaultFsConfig load(File file)
            throws ConfigurationException, IOException {
        return load(new FileInputStream(file), file.getName());
    }

    public static VaultFsConfig load(InputStream in, String name)
            throws ConfigurationException, IOException {
        try {
            org.apache.jackrabbit.vault.fs.api.VaultFsConfig cfg = org.apache.jackrabbit.vault.fs.config.AbstractVaultFsConfig.load(in, name);
            return JrVltVaultFsConfigAdapter.create(cfg);
        } catch (org.apache.jackrabbit.vault.fs.config.ConfigurationException e) {
            throw new ConfigurationException(e);
        }
    }


}