/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

import com.day.jcr.vault.fs.api.VaultFsConfig;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.impl.JrVltNodeTypeSet;
import com.day.jcr.vault.fs.impl.JrVltNodeTypeSetAdapter;
import com.day.jcr.vault.fs.impl.JrVltVaultFsConfig;
import com.day.jcr.vault.fs.impl.JrVltVaultFsConfigAdapter;
import com.day.jcr.vault.fs.impl.JrVltWorkspaceFilter;
import com.day.jcr.vault.fs.spi.NodeTypeSet;
import com.day.jcr.vault.fs.spi.PrivilegeDefinitions;

/**
 * Abstracts the way of accessing the vault specific meta-info of a checkout.
 */
public class DefaultMetaInf implements MetaInf {

    private final org.apache.jackrabbit.vault.fs.config.DefaultMetaInf inf;

    public DefaultMetaInf() {
        this.inf = new org.apache.jackrabbit.vault.fs.config.DefaultMetaInf();
    }

    public DefaultMetaInf(org.apache.jackrabbit.vault.fs.config.DefaultMetaInf inf) {
        this.inf = inf;
    }

    /**
     * Returns the package format version of this package. If the package
     * lacks this information, {@link #FORMAT_VERSION_2} is returned, since this
     * feature was implemented recently.
     *
     * @return the package format version
     * @since 2.0
     */
    public int getPackageFormatVersion() {
        return inf.getPackageFormatVersion();
    }

    public void loadFilter(InputStream in, String systemId) throws ConfigurationException, IOException {
        try {
            inf.loadFilter(in, systemId);
        } catch (org.apache.jackrabbit.vault.fs.config.ConfigurationException e) {
            throw new ConfigurationException(e);
        }
    }

    public void loadConfig(InputStream in, String systemId) throws ConfigurationException, IOException {
        try {
            inf.loadConfig(in, systemId);
        } catch (org.apache.jackrabbit.vault.fs.config.ConfigurationException e) {
            throw new ConfigurationException(e);
        }
    }

    public void loadSettings(InputStream in, String systemId) throws ConfigurationException, IOException {
        try {
            inf.loadSettings(in, systemId);
        } catch (org.apache.jackrabbit.vault.fs.config.ConfigurationException e) {
            throw new ConfigurationException(e);
        }
    }

    public void loadProperties(InputStream in, String systemId) throws IOException {
        inf.loadProperties(in, systemId);
    }

    public void loadPrivileges(InputStream in, String systemId) throws IOException {
        inf.loadPrivileges(in, systemId);
    }

    public void save(File metaDir) throws IOException {
        inf.save(metaDir);
    }

    public VaultSettings getSettings() {
        return VaultSettings.create(inf.getSettings());
    }

    public void setSettings(VaultSettings settings) {
        inf.setSettings(settings.unwrap());
    }

    public WorkspaceFilter getFilter() {
        return JrVltWorkspaceFilter.create(inf.getFilter());
    }

    public void setFilter(WorkspaceFilter filter) {
        inf.setFilter(JrVltWorkspaceFilter.create(filter));
    }

    public VaultFsConfig getConfig() {
        return JrVltVaultFsConfigAdapter.create(inf.getConfig());
    }

    public void setConfig(VaultFsConfig config) {
        inf.setConfig(JrVltVaultFsConfig.create(config));
    }

    public Properties getProperties() {
        return inf.getProperties();
    }

    public void setProperties(Properties properties) {
        inf.setProperties(properties);
    }

    public Collection<NodeTypeSet> getNodeTypes() {
        Collection<org.apache.jackrabbit.vault.fs.spi.NodeTypeSet> set = inf.getNodeTypes();
        if (set == null || set.isEmpty()) {
            return Collections.emptySet();
        }
        List<NodeTypeSet> ret = new ArrayList<NodeTypeSet>(set.size());
        for (org.apache.jackrabbit.vault.fs.spi.NodeTypeSet s: set) {
            ret.add(JrVltNodeTypeSetAdapter.create(s));
        }
        return ret;
    }

    public PrivilegeDefinitions getPrivileges() {
        return new PrivilegeDefinitions(inf.getPrivileges());
    }

    public void setCNDs(Collection<NodeTypeSet> cnds) {
        if (cnds == null || cnds.isEmpty()) {
            return;
        }
        Collection<org.apache.jackrabbit.vault.fs.spi.NodeTypeSet> set = new ArrayList<org.apache.jackrabbit.vault.fs.spi.NodeTypeSet>(cnds.size());
        for (NodeTypeSet s: cnds) {
            set.add(JrVltNodeTypeSet.create(s));
        }
        inf.setCNDs(set);
    }

    public boolean hasDefinition() {
        return inf.hasDefinition();
    }

    public void setHasDefinition(boolean hasDefinition) {
        inf.setHasDefinition(hasDefinition);
    }
}