/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.config;

import java.io.File;
import java.io.IOException;

import com.day.jcr.vault.fs.impl.JrVltMetaInfAdapter;

/**
 * Represents the root of a vault export or a vlt checkout. it has the following
 * structure:
 *
 * <xmp>
 * root
 * |-- META-INF
 * |   `-- vault
 * |       |-- config.xml
 * |       |-- filter.xml
 * |       |-- nodetypes.cnd
 * |       `-- properties.xml
 * `-- jcr_root
 *     :
 * </xmp>
 *
 */
public class ExportRoot {

    private final org.apache.jackrabbit.vault.fs.config.ExportRoot root;

    public ExportRoot(File rootDir) {
        root = new org.apache.jackrabbit.vault.fs.config.ExportRoot(rootDir);
    }

    private ExportRoot(org.apache.jackrabbit.vault.fs.config.ExportRoot root) {
        this.root = root;
    }

    /**
     * Checks if this export root already has the necessary structure setup.
     * @return <code>true</code> if valid.
     */
    public boolean isValid() {
        return root.isValid();
    }

    public void assertValid() throws IOException {
        root.assertValid();
    }

    /**
     * Creates the necessary directories if they do not exist yet.
     * @throws IOException if an I/O error occurs
     */
    public void create() throws IOException {
        root.create();
    }

    /**
     * Returns the meta information.
     * @return the meta information.
     */
    public MetaInf getMetaInf() {
        return JrVltMetaInfAdapter.create(root.getMetaInf());
    }

    public File getRoot() {
        return root.getRoot();
    }

    public File getJcrRoot() {
        return root.getJcrRoot();
    }

    public File getMetaDir() {
        return root.getMetaDir();
    }

    public static ExportRoot findRoot(File cwd) {
        org.apache.jackrabbit.vault.fs.config.ExportRoot root = org.apache.jackrabbit.vault.fs.config.ExportRoot.findRoot(cwd);
        return root == null ? null : new ExportRoot(root);
    }

}