/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.config;

import java.util.Collection;
import java.util.Properties;

import com.day.jcr.vault.fs.api.VaultFsConfig;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.spi.NodeTypeSet;
import com.day.jcr.vault.fs.spi.PrivilegeDefinitions;

/**
 * Abstracts the way of accessing the vault specific meta-info of a checkout.
 */
public interface MetaInf {

    /**
     * Format Version 1. Used for content assembled until Vault 1.2.8
     * @since 2.0
     */
    public static int FORMAT_VERSION_1 = 1;

    /**
     * Format Version 2. Used for content assembled since Vault 1.2.9
     * @since 2.0
     */
    public static int FORMAT_VERSION_2 = 2;

    /**
     * Name of the package format version
     * @since 2.0
     */
    public static String PACKAGE_FORMAT_VERSION = "packageFormatVersion";

    /**
     * Name of the 'created' property
     */
    public static String CREATED = "created";

    /**
     * Name of the 'created by' property
     */
    public static String CREATED_BY = "createdBy";
    
    /**
     * Returns the package format version of this package. If the package
     * lacks this information, {@link #FORMAT_VERSION_2} is returned, since this
     * feature was implemented recently.
     *
     * @return the package format version
     * @since 2.0
     */
    int getPackageFormatVersion();

    /**
     * Returns the vault settings.
     * @return the vault settings.
     */
    VaultSettings getSettings();

    /**
     * Returns the workspace filter.
     * @return the workspace filter.
     */
    WorkspaceFilter getFilter();

    /**
     * Returns the vault config
     * @return the vault config
     */
    VaultFsConfig getConfig();

    /**
     * Returns the properties
     * @return the properties
     */
    Properties getProperties();

    /**
     * Returns the node types
     * @return the node types
     */
    Collection<NodeTypeSet> getNodeTypes();

    /**
     * Returns custom privileges defined in the meta inf.
     * @return a collection of custom privileges.
     * @since 3.0
     */
    PrivilegeDefinitions getPrivileges();
    
    /**
     * Checks if the meta-inf contains a serialized definition.
     * @return <code>true</code> if it contains a serialized definition.
     */
    boolean hasDefinition();

}