/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.config;

import java.util.Set;

/**
 * <code>VaultUserConfig</code>...
 *
 */
public class VaultSettings extends AbstractConfig {

    public static final String ELEM_IGNORE = "ignore";

    public static final String ATTR_IGNORE_NAME = "name";

    private org.apache.jackrabbit.vault.fs.config.VaultSettings settings;

    private VaultSettings(org.apache.jackrabbit.vault.fs.config.VaultSettings settings) {
        super(settings);
        this.settings = settings;
    }

    public static VaultSettings create(org.apache.jackrabbit.vault.fs.config.VaultSettings settings) {
        return settings == null ? null : new VaultSettings(settings);
    }

    public org.apache.jackrabbit.vault.fs.config.VaultSettings unwrap() {
        return settings;
    }

    public Set<String> getIgnoredNames() {
        return settings.getIgnoredNames();
    }

    public boolean isIgnored(String name) {
        return settings.isIgnored(name);
    }

    public static VaultSettings createDefault() {
        return new VaultSettings(org.apache.jackrabbit.vault.fs.config.VaultSettings.createDefault());
    }
}