/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.filter;

import java.util.HashSet;
import java.util.Set;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;

import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.ItemFilter;
import com.day.jcr.vault.util.JcrConstants;

/**
 * Implements an item filter that matches if a node only has the primary
 * properties: jcr:primaryType, jcr:mixinTypes, jcr:uuid, jcr:created and
 * jcr:createdBy
 */
public class BaseFilter implements ItemFilter {

    private static final Set<String> validNames = new HashSet<String>();
    static {
        validNames.add(JcrConstants.JCR_PRIMARYTYPE);
        validNames.add(JcrConstants.JCR_MIXINTYPES);
        validNames.add(JcrConstants.JCR_UUID);
        validNames.add(JcrConstants.JCR_CREATED);
        validNames.add(JcrConstants.JCR_CREATED_BY);
    }


    /**
     * {@inheritDoc}
     */
    public boolean matches(Item item, int depth) throws RepositoryException {
        if (item.isNode()) {
            PropertyIterator iter = ((Node) item).getProperties();
            while (iter.hasNext()) {
                String name = iter.nextProperty().getName();
                if (!validNames.contains(name)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /**
     * {@inheritDoc}
     */
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.printf(isLast, "%s:", getClass().getSimpleName());
    }
}