/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.filter;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;

import com.day.jcr.vault.util.JcrConstants;

/**
 * Defines an filter that matches file/folder like nodes. It matches
 * all nt:hierarchyNode nodes that have or define a jcr:content
 * child node.
 */
public class FileFolderNodeFilter extends DepthItemFilter {

    /**
     * {@inheritDoc}
     *
     * Returns <code>true</code> if the item is a node of type nt:hierarchyNode
     * that has or defines a 'jcr:content' child node.
     */
    public boolean matches(Item item) throws RepositoryException {
        if (item.isNode()) {
            Node node = (Node) item;
            if (node.isNodeType(JcrConstants.NT_HIERARCHYNODE)) {
                if (node.hasNode(JcrConstants.JCR_CONTENT)) {
                    return true;
                } else {
                    for (NodeDefinition pd: node.getPrimaryNodeType().getChildNodeDefinitions()) {
                        if (pd.getName().equals(JcrConstants.JCR_CONTENT)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

}