/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.filter;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

import com.day.jcr.vault.fs.api.DumpContext;

/**
 * <code>IsNodeFilter</code>...
 *
 */
public class IsMandatoryFilter extends DepthItemFilter {

    private boolean isMandatory = true;

    public IsMandatoryFilter() {
    }

    public IsMandatoryFilter(boolean isMandatory, int minDepth, int maxDepth) {
        super(minDepth, maxDepth);
        this.isMandatory = isMandatory;
    }

    public IsMandatoryFilter(boolean isMandatory) {
        this(isMandatory, 0, Integer.MAX_VALUE);
    }

    public void setCondition(String node) {
        isMandatory = Boolean.valueOf(node);
    }

    public void setIsMandatory(String node) {
        isMandatory = Boolean.valueOf(node);
    }

    public boolean matches(Item item) throws RepositoryException {
        if (item.isNode()) {
            return ((Node) item).getDefinition().isMandatory() == isMandatory;
        } else {
            return ((Property) item).getDefinition().isMandatory() == isMandatory;
        }
    }

    /**
     * {@inheritDoc}
     */
    public void dump(DumpContext ctx, boolean isLast) {
        super.dump(ctx, isLast);
        ctx.indent(isLast);
        ctx.printf(true, "isMandatory: %b", isMandatory);
        ctx.outdent();
    }
    
}