/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.filter;

import javax.jcr.Item;
import javax.jcr.RepositoryException;

import com.day.jcr.vault.fs.api.DumpContext;

/**
 * Item filter that checks if an item is a node.
 *
 */
public class IsNodeFilter extends DepthItemFilter {

    /**
     * Polarity of this filter
     */
    private boolean isNode = true;

    /**
     * Default constructor.
     */
    public IsNodeFilter() {
        super(1, Integer.MAX_VALUE);
    }

    /**
     * Creates a new node item filter.
     *
     * @param polarity the polarity of this filter. if <code>true</code> it matches
     * nodes, if <code>false</code> it matches properties.
     * @param minDepth the minimum depth
     * @param maxDepth the maximum depth
     *
     * @see DepthItemFilter
     */
    public IsNodeFilter(boolean polarity, int minDepth, int maxDepth) {
        super(minDepth, maxDepth);
        isNode = polarity;
    }

    /**
     * Creates a new node item filter
     * @param polarity the polarity of this filter. if <code>true</code> it matches
     * nodes, if <code>false</code> it matches properties.
     */
    public IsNodeFilter(boolean polarity) {
        this(polarity, 1, Integer.MAX_VALUE);
    }

    /**
     * Sets the polarity of this filter. If set to <code>true</code> this filter
     * matches nodes otherwise properties.
     *
     * @param polarity the polarity
     */
    public void setPolarity(String polarity) {
        setIsNode(polarity);
    }

    /**
     * Sets the polarity of this filter. If set to <code>true</code> this filter
     * matches nodes otherwise properties.
     *
     * @param polarity the polarity
     */
    public void setIsNode(String polarity) {
        isNode = Boolean.valueOf(polarity);
    }

    /**
     * {@inheritDoc}
     *
     * Returns <code>true</code> if the item is a node and the polarity is
     * positive (true).
     */
    public boolean matches(Item item) throws RepositoryException {
        return item.isNode() == isNode;
    }

    /**
     * {@inheritDoc}
     */
    public void dump(DumpContext ctx, boolean isLast) {
        super.dump(ctx, isLast);
        ctx.indent(isLast);
        ctx.printf(true, "isNode: %b", isNode);
        ctx.outdent();
    }

}