/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.filter;

import javax.jcr.Item;
import javax.jcr.RepositoryException;

import com.day.jcr.vault.fs.api.DumpContext;

/**
 * Filters items according to their names.
 *
 */
public class NameItemFilter extends DepthItemFilter {

    /**
     * The name to filter on
     */
    private String name;

    /**
     * Default constructor
     */
    public NameItemFilter() {
    }

    /**
     * Creates a new name filter with the given name and depths
     * @param name the name to filter on
     * @param minDepth the minimal depth
     * @param maxDepth the maximal depth
     */
    public NameItemFilter(String name, int minDepth, int maxDepth) {
        super(minDepth, maxDepth);
        this.name = name;
    }

    /**
     * Creates a new name filter with the given name.
     * @param name the name to filter on
     */
    public NameItemFilter(String name) {
        this(name, 0, Integer.MAX_VALUE);
    }

    /**
     * Sets the name
     * @param name the name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * {@inheritDoc}
     *
     * Returns <code>true</code> if the name of the given item is equal to
     * the configured name.
     */
    public boolean matches(Item item) throws RepositoryException {
        return item.getName().equals(name);
    }

    /**
     * {@inheritDoc}
     */
    public void dump(DumpContext ctx, boolean isLast) {
        super.dump(ctx, true);
        ctx.indent(isLast);
        ctx.printf(true, "name: %s", name);
        ctx.outdent();
    }

}