/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.io;

/**
 * <code>AccessControlHandling</code> defines the behavior when importing
 * access control nodes.
 */
public enum AccessControlHandling {

    /**
     * Ignores the packaged access control and leaves the target unchanged.
     */
    IGNORE,

    /**
     * Applies the access control provided with the package to the target. this
     * also removes existing access control.
     */
    OVERWRITE,

    /**
     * Tries to merge access control provided with the package with the one on
     * the target.
     *
     * This is currently not fully supported and behaves like {@link #OVERWRITE}
     * for existing ACLs. ACLs not in the package are retained.
     */
    MERGE,

    /**
     * Tries to merge access control in the content with the one provided by the package.
     *
     * This is currently not fully supported and behaves like {@link #IGNORE}
     * for existing ACLs. ACLs not in the package are retained.
     */
    MERGE_PRESERVE,

    /**
     * Clears all access control on the target system.
     */
    CLEAR,

}
