/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.io;

import java.util.Map;
import java.util.TreeMap;

import com.day.jcr.vault.util.PathComparator;

/**
 * Provides information about an export
 */
public class ExportInfo {

    private final TreeMap<String, Entry> entries = new TreeMap<String, Entry>(new PathComparator(true));

    public enum Type {
        ADD,
        DELETE,
        UPDATE,
        MKDIR,
        RMDIR,
        NOP
    }

    public void update(Type type, String path) {
        Entry e = entries.get(path);
        if (e == null) {
            e = new Entry(type, path);
        } else if (e.type != Type.ADD) {
            // don't overwrite ADDs
            e = new Entry(type, path);
        }
        entries.put(path, e);
    }

    public Map<String, Entry> getEntries() {
        return entries;
    }

    public static class Entry {

        public final Type type;

        public final String path;

        public Entry(Type type, String path) {
            this.type = type;
            this.path = path;
        }

        @Override
        public String toString() {
            return type + " " + path;
        }
    }
}