/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.io;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import com.day.jcr.vault.fs.api.ImportMode;
import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.impl.CompatHelper;
import com.day.jcr.vault.fs.impl.JrVltProgressTrackerListener;
import com.day.jcr.vault.fs.impl.JrVltProgressTrackerListenerAdapter;
import com.day.jcr.vault.fs.impl.JrVltWorkspaceFilter;

/**
 * Option that control the package import.
 *
 * @since 2.3.12 (moved from com.day.jcr.packaging.ImportOptions)
 */
public class ImportOptions {

    private final JrVltImportOptions opts;

    public ImportOptions() {
        opts = new JrVltImportOptions();
    }

    public ImportOptions(ImportOptions base) {
        opts = base == null ? new JrVltImportOptions() : base.toJrVltImportOptions();
    }

    private ImportOptions(org.apache.jackrabbit.vault.fs.io.ImportOptions opts) {
        this.opts = new JrVltImportOptions(opts);
    }

    public static ImportOptions create(org.apache.jackrabbit.vault.fs.io.ImportOptions opts) {
        return opts == null ? null : new ImportOptions(opts);
    }

    public boolean isStrict() {
        return opts.isStrict();
    }

    public void setAutoSaveThreshold(int threshold) {
        opts.setAutoSaveThreshold(threshold);
    }

    public void setListener(ProgressTrackerListener listener) {
        opts.setListener(JrVltProgressTrackerListener.create(listener));
    }

    public int getAutoSaveThreshold() {
        return opts.getAutoSaveThreshold();
    }

    public File getPatchDirectory() {
        return opts.getPatchDirectory();
    }

    public ClassLoader getHookClassLoader() {
        return opts.getHookClassLoader();
    }

    public void setFilter(WorkspaceFilter filter) {
        opts.setFilter(JrVltWorkspaceFilter.create(filter));
    }

    public String getPatchParentPath() {
        return opts.getPatchParentPath();
    }

    public void setImportMode(ImportMode importMode) {
        opts.setImportMode(CompatHelper.convert(importMode));
    }

    public boolean isDryRun() {
        return opts.isDryRun();
    }

    public void setDryRun(boolean dryRun) {
        opts.setDryRun(dryRun);
    }

    public void setNonRecursive(boolean nonRecursive) {
        opts.setNonRecursive(nonRecursive);
    }

    public void setPatchDirectory(File patchDirectory) throws IOException {
        opts.setPatchDirectory(patchDirectory);
    }

    public ProgressTrackerListener getListener() {
        return JrVltProgressTrackerListenerAdapter.create(opts.getListener());
    }

    public void setAccessControlHandling(AccessControlHandling acHandling) {
        opts.setAccessControlHandling(CompatHelper.convert(acHandling));
    }

    public ImportMode getImportMode() {
        return CompatHelper.convert(opts.getImportMode());
    }

    public void setPatchKeepInRepo(boolean patchKeepInRepo) {
        opts.setPatchKeepInRepo(patchKeepInRepo);
    }

    public boolean isPatchKeepInRepo() {
        return opts.isPatchKeepInRepo();
    }

    public void setPatchParentPath(String patchParentPath) {
        opts.setPatchParentPath(patchParentPath);
    }

    public void setCndPattern(String cndPattern) throws PatternSyntaxException {
        opts.setCndPattern(cndPattern);
    }

    public AccessControlHandling getAccessControlHandling() {
        return CompatHelper.convert(opts.getAccessControlHandling());
    }

    public WorkspaceFilter getFilter() {
        return JrVltWorkspaceFilter.create(opts.getFilter());
    }

    public Pattern getCndPattern() {
        return opts.getCndPattern();
    }

    public boolean isNonRecursive() {
        return opts.isNonRecursive();
    }

    public void setHookClassLoader(ClassLoader hookClassLoader) {
        opts.setHookClassLoader(hookClassLoader);
    }

    public void setStrict(boolean strict) {
        opts.setStrict(strict);
    }

    public JrVltImportOptions toJrVltImportOptions() {
        return opts;
    }
}