/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.io;

import java.io.IOException;
import java.util.List;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.impl.JrVltArchive;

/**
 * <code>AbstractImporter</code>
 *
 * file/directory combinations
 *
 * 1. plain files
 *    + foo
 *      - test.gif
 *
 * 2. plain files + special folder
 *    + foo
 *      - .content.xml
 *      + bar
 *        - test.gif
 *
 * 3. special file
 *    + foo
 *      - test.gif
 *      - test.gif.dir
 *        - .content.xml
 *
 * 4. special file + sub files
 *    + foo
 *      - test.gif
 *      - test.gif.dir
 *        - .content.xml
 *        + _jcr_content
 *          - thumbnail.gif
 *
 * 4. special file + sub special files
 *    + foo
 *      - test.gif
 *      - test.gif.dir
 *        - .content.xml
 *        + _jcr_content
 *          - thumbnail.gif
 *          + thumbnail.gif.dir
 *            - .content.xml
 *
 * 5. file/folder structure
 *    + foo
 *      + en
 *        - .content.xml
 *        + _cq_content
 *          - thumbnail.gif
 *        + company
 *          - .content.xml
 */
public class Importer {

    private org.apache.jackrabbit.vault.fs.io.Importer importer;

    public Importer() {
         importer = new org.apache.jackrabbit.vault.fs.io.Importer();
    }

    public Importer(ImportOptions opts) {
         importer = new org.apache.jackrabbit.vault.fs.io.Importer(opts.toJrVltImportOptions());
    }

    public ImportOptions getOptions() {
        return ImportOptions.create(importer.getOptions());
    }

    public List<String> getSubPackages() {
        return importer.getSubPackages();
    }

    /**
     * Debug settings to allows to produce failures after each <code>failAfterEach</code> save.
     * @param failAfterEach cardinal indicating when to fail
     */
    public void setDebugFailAfterSave(int failAfterEach) {
        importer.setDebugFailAfterSave(failAfterEach);
    }

    /**
     /**
     * Runs the importer
     *
     * @param archive the archive to import
     * @param importRoot the root node to import
     *
     * @throws com.day.jcr.vault.fs.config.ConfigurationException if the importer is not properly configured
     * @throws java.io.IOException if an I/O error occurs
     * @throws javax.jcr.RepositoryException if an repository error occurs
     *
     * @since 2.3.20
     */
    public void run(Archive archive, Node importRoot)
            throws IOException, RepositoryException, ConfigurationException {
        try {
            importer.run(JrVltArchive.create(archive), importRoot);
        } catch (org.apache.jackrabbit.vault.fs.config.ConfigurationException e) {
            throw new ConfigurationException(e);
        }
    }

    public boolean hasErrors() {
        return importer.hasErrors();
    }

    public void checkinNodes(Session session) {
        importer.checkinNodes(session);
    }

    public void applyMemberships(Session session) {
        importer.applyMemberships(session);
    }


}