/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.jcr.vault.fs.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.impl.JrVltArchive;
import com.day.jcr.vault.fs.impl.JrVltMetaInfAdapter;
import com.day.jcr.vault.fs.impl.JrVltVaultInputSourceAdapter;

/**
 * <code>JrVltArchive</code>...
 */
public class JrVltArchiveAdapter implements Archive {

    private final org.apache.jackrabbit.vault.fs.io.Archive archive;

    protected JrVltArchiveAdapter(org.apache.jackrabbit.vault.fs.io.Archive archive) {
        this.archive = archive;
    }

    public org.apache.jackrabbit.vault.fs.io.Archive unwrap() {
        return archive;
    }

    public static Archive create(org.apache.jackrabbit.vault.fs.io.Archive archive) {
        if (archive instanceof JrVltArchive) {
            return ((JrVltArchive) archive).unwrap();
        }
        return archive == null ? null : new JrVltArchiveAdapter(archive);
    }

    public void open(boolean strict) throws IOException {
        archive.open(strict);
    }

    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        return archive.openInputStream(JrVltArchive.Entry.create(entry));
    }

    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        return JrVltVaultInputSourceAdapter.create(archive.getInputSource(JrVltArchive.Entry.create(entry)));
    }

    public Archive.Entry getJcrRoot() throws IOException {
        return EntryAdapter.create(archive.getJcrRoot());
    }

    public Archive.Entry getRoot() throws IOException {
        return EntryAdapter.create(archive.getRoot());
    }

    public MetaInf getMetaInf() {
        return JrVltMetaInfAdapter.create(archive.getMetaInf());
    }

    public Archive.Entry getEntry(String path) throws IOException {
        return EntryAdapter.create(archive.getEntry(path));
    }

    public Archive getSubArchive(String root, boolean asJcrRoot) throws IOException {
        return JrVltArchiveAdapter.create(archive.getSubArchive(root, asJcrRoot));
    }

    public void close() {
        archive.close();
    }

    public static class EntryAdapter implements Archive.Entry {

        private final org.apache.jackrabbit.vault.fs.io.Archive.Entry entry;

        private EntryAdapter(org.apache.jackrabbit.vault.fs.io.Archive.Entry entry) {
            this.entry = entry;
        }

        public org.apache.jackrabbit.vault.fs.io.Archive.Entry unwrap() {
            return entry;
        }

        public static Archive.Entry create(org.apache.jackrabbit.vault.fs.io.Archive.Entry entry) {
            if (entry instanceof JrVltArchive.Entry) {
                return ((JrVltArchive.Entry) entry).unwrap();
            }
            return new EntryAdapter(entry);
        }

        public String getName() {
            return entry.getName();
        }

        public boolean isDirectory() {
            return entry.isDirectory();
        }

        public Collection<? extends Archive.Entry> getChildren() {
            Collection<? extends org.apache.jackrabbit.vault.fs.io.Archive.Entry> entries =  entry.getChildren();
            List<Archive.Entry> ret = new ArrayList<Archive.Entry>(entries.size());
            for (org.apache.jackrabbit.vault.fs.io.Archive.Entry e: entries) {
                ret.add(create(e));
            }
            return ret;
        }

        public Archive.Entry getChild(String name) {
            return create(entry.getChild(name));
        }
    }

}