/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.io;

import org.apache.jackrabbit.vault.packaging.InstallHookProcessor;
import org.apache.jackrabbit.vault.packaging.InstallHookProcessorFactory;

import com.day.jcr.vault.packaging.impl.JrVltInstallHookProcessor;

/**
 * Option that control the package import.
 *
 * @since 2.3.12 (moved from com.day.jcr.packaging.ImportOptions)
 */
public class JrVltImportOptions extends org.apache.jackrabbit.vault.fs.io.ImportOptions implements InstallHookProcessorFactory {

    public JrVltImportOptions() {
    }

    public JrVltImportOptions(org.apache.jackrabbit.vault.fs.io.ImportOptions base) {
        super(base);
    }

    public InstallHookProcessor createInstallHookProcessor() {
        return new JrVltInstallHookProcessor();
    }

    @Override
    public org.apache.jackrabbit.vault.fs.io.ImportOptions copy() {
        return new JrVltImportOptions(this);
    }

}