/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.io;

import java.io.File;

/**
 * The zip archive implements bridge between the ZipStreamArchive and the
 * ZipFileArchive. the former is needed due to a bug in ZipFile of jdk1.5 that
 * causes problems with zip files with a lot of entries.
 */
public class ZipArchive extends JrVltArchiveAdapter {

    public ZipArchive(File zipFile) {
        super(new org.apache.jackrabbit.vault.fs.io.ZipArchive(zipFile));
    }

}