/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.spi;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

/**
 * <code>AccessControlManagement</code>...
 */
public interface ACLManagement {

    /**
     * Checks if the given node type name is used for ACLs
     * @param name the node type name
     * @return <code>true</code> if used for ACLs
     */
    boolean isACLNodeType(String name);

    /**
     * Checks if the given node type name is use as access controllable
     * mixin.
     * @param name the node type name
     * @return <code>true</code> if the name is the mixin name
     */
    boolean isAccessControllableMixin(String name);


    /**
     * Checks if the given node is an ACL node.
     * @param node the node
     * @return <code>true</code> if it's an ACL node.
     * @throws RepositoryException if an error occurs
     */
    boolean isACLNode(Node node) throws RepositoryException;

    /**
     * Checks if the given node is access controllable, i.e. has the respective
     * mixin and adds it if missing.
     *
     * @param node the node to check
     * @return <code>true</code> if was made access controllable
     * @throws RepositoryException if an error occurs
     */
    boolean ensureAccessControllable(Node node) throws RepositoryException;

    /**
     * Removes all ACLs from the given node.
     *
     * @param node the node
     * @throws RepositoryException if an error occurs
     */
    void clearACL(Node node) throws RepositoryException;
}