/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.spi;

import java.util.Collection;

import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;

/**
 * Defines a set of privilege definitions together with the used namespaces
 */
public class PrivilegeDefinitions {

    private final org.apache.jackrabbit.vault.fs.spi.PrivilegeDefinitions privs;

    public PrivilegeDefinitions(org.apache.jackrabbit.vault.fs.spi.PrivilegeDefinitions privs) {
        this.privs = privs;
    }

    public PrivilegeDefinitions() {
        this.privs = new org.apache.jackrabbit.vault.fs.spi.PrivilegeDefinitions();
    }

    public org.apache.jackrabbit.vault.fs.spi.PrivilegeDefinitions unwrap() {
        return privs;
    }

    public Collection<PrivilegeDefinition> getDefinitions() {
        return privs.getDefinitions();
    }

    public NamespaceMapping getNamespaceMapping() {
        return privs.getNamespaceMapping();
    }
}