/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.spi;

import com.day.jcr.vault.fs.api.ProgressTrackerListener;

/**
 * <code>ProgressTracker</code>...
 *
 */
public class ProgressTracker {

    protected ProgressTrackerListener listener;

    private ProgressTrackerListener.Mode mode = ProgressTrackerListener.Mode.TEXT;

    private boolean enabled = true;

    public ProgressTracker() {
    }

    public ProgressTracker(ProgressTrackerListener listener) {
        this.listener = listener;
    }

    public void setListener(ProgressTrackerListener listener) {
        this.listener = listener;
    }

    public ProgressTrackerListener getListener() {
        return listener;
    }

    public void track(String action, String path) {
        if (enabled && listener != null) {
            listener.onMessage(mode, action, path);
        }
    }

    public void track(Exception e, String path) {
        if (enabled && listener != null) {
            listener.onError(mode, path, e);
        }
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ProgressTrackerListener.Mode getMode() {
        return mode;
    }

    public ProgressTrackerListener.Mode setMode(ProgressTrackerListener.Mode mode) {
        ProgressTrackerListener.Mode prev = this.mode;
        this.mode = mode;
        return prev;
    }


}