/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.spi;

import java.io.Writer;
import java.util.Set;

import javax.jcr.Session;

/**
 * Defines a general provider for the JCR version specific services such as node
 * type management and access control handling.
 */
public interface ServiceProvider {

    /**
     * Returns the JCR version of the underlying repository
     * @return the jcr version
     */
    JcrVersion getJCRVersion();

    /**
     * Returns the names of the default built in nodetypes of the underlying
     * repository.
     *
     * @return a set of names
     */
    Set<String> getBuiltInNodeTypeNames();

    /**
     * Returns the default node type installer.
     * @param session the session to use
     * @return the default node type installer.
     */
    NodeTypeInstaller getDefaultNodeTypeInstaller(Session session);

    /**
     * Returns the default privilege installer.
     * @param session the session to use
     * @return the default privilege installer.
     */
    PrivilegeInstaller getDefaultPrivilegeInstaller(Session session);

    /**
     * Returns the default CND reader.
     * @return the default CND reader.
     */
    CNDReader getCNDReader();

    /**
     * Returns the default CND writer
     * @param out the writer
     * @param s the session
     * @param includeNS <code>true</code> if namespace should be included
     * @return the default CND writer
     */
    CNDWriter getCNDWriter(Writer out, Session s, boolean includeNS);

    /**
     * Returns the repository dependant ACL management
     * @return the ACL management
     */
    ACLManagement getACLManagement();

    /**
     * Returns the repository dependant User management or <code>null</code> if
     * the repository does not require a separate user handling.
     *
     * @return repository dependant User management or <code>null</code>
     */
    UserManagement getUserManagement();
}