/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.fs.spi;

import javax.jcr.Session;

/**
 * <code>UserManagement</code>...
 */
public interface UserManagement {

    /**
     * Checks if the given node type name is used for a User node.
     *
     * @param ntName the node type name
     * @return <code>true</code> if used for a User node.
     */
    boolean isAuthorizableNodeType(String ntName);

    /**
     * Returns the path of the authorizable or <code>null</code> if not exists.
     * @param name the authorizable name
     * @param session the session to access the repository
     * @return path of authorizable
     *
     * @since 2.3.26
     */
    String getAuthorizablePath(Session session, String name);

    /**
     * Adds the given memberships to the specified group.
     * @param session session to operate on
     * @param id id of group
     * @param membersUUID uuids of members
     * @since 2.3.28
     */
    void addMembers(Session session, String id, String[] membersUUID);
}