/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.packaging;


import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.impl.JrVltMetaInf;
import com.day.jcr.vault.fs.impl.JrVltMetaInfAdapter;
import com.day.jcr.vault.fs.impl.JrVltProgressTrackerListener;
import com.day.jcr.vault.fs.impl.JrVltProgressTrackerListenerAdapter;

/**
 * Holds options used for exporting.
 *
 * @deprecated since 2.5.0. Use the org.apache.jackrabbit.vault API instead.
 */
@Deprecated
public class ExportOptions {

    private final org.apache.jackrabbit.vault.packaging.ExportOptions opts;

    public ExportOptions() {
        this.opts = new org.apache.jackrabbit.vault.packaging.ExportOptions();
    }

    private ExportOptions(org.apache.jackrabbit.vault.packaging.ExportOptions opts) {
        this.opts = opts;
    }

    public static ExportOptions create(org.apache.jackrabbit.vault.packaging.ExportOptions opts) {
        return opts == null ? null : new ExportOptions(opts);
    }

    public ProgressTrackerListener getListener() {
        return JrVltProgressTrackerListenerAdapter.create(opts.getListener());
    }

    public void setMetaInf(MetaInf metaInf) {
        opts.setMetaInf(JrVltMetaInf.create(metaInf));
    }

    public void setMountPath(String mountPath) {
        opts.setMountPath(mountPath);
    }

    public String getMountPath() {
        return opts.getMountPath();
    }

    public MetaInf getMetaInf() {
        return JrVltMetaInfAdapter.create(opts.getMetaInf());
    }

    public void setListener(ProgressTrackerListener listener) {
        opts.setListener(JrVltProgressTrackerListener.create(listener));
    }

    public void setRootPath(String rootPath) {
        opts.setRootPath(rootPath);
    }

    public void setPostProcessor(ExportPostProcessor postProcessor) {
        throw new UnsupportedOperationException("Post processors are not supported anymore " +
                "in the com.day.jcr.vault.packaging.ExportOptions. " +
                "Use the Jackrabbit FileVault interface instead.");
    }

    public org.apache.jackrabbit.vault.packaging.ExportOptions getJackrabbitFileVaultExportOptions() {
        return opts;
    }

    public String getRootPath() {
        return opts.getRootPath();
    }

    public ExportPostProcessor getPostProcessor() {
        return null;
    }

    public org.apache.jackrabbit.vault.packaging.ExportOptions toJrVltExportOptions() {
        org.apache.jackrabbit.vault.packaging.ExportOptions ret = new org.apache.jackrabbit.vault.packaging.ExportOptions();
        ret.setListener(JrVltProgressTrackerListener.create(getListener()));
        ret.setMetaInf(JrVltMetaInf.create(getMetaInf()));
        ret.setMountPath(getMountPath());
        ret.setRootPath(getRootPath());
        return ret;
    }
}