/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.packaging;

import javax.jcr.Session;

/**
 * The install context is passed to {@link InstallHook}s during the different
 * phases of a package installation.
 *
 * @deprecated since 2.5.0. Use the org.apache.jackrabbit.vault API instead.
 */
@Deprecated
public interface InstallContext {

    /**
     * The current phase of a package installation
     */
    enum Phase {

        /**
         * Specifies that the package is not yet installed and the hooks can
         * do some pre-installation work
         */
        PREPARE,

        /**
         * Specifies that the prepare phase failed and the hoos can do some
         * cleanup work.
         */
        PREPARE_FAILED,

        /**
         * Specifies that the package was successfully installed and the hooks
         * can do some post-installation work and cleanup.
         */
        INSTALLED,

        /**
         * Specifies that the package installation failed and the hooks can
         * do some cleanup work.
         */
        INSTALL_FAILED,

        /**
         * Specifies that the hook is going to be discarded. this is guaranteed
         * to be called at the end of an installation process.
         */
        END
    }

    /**
     * Returns the current installation phase
     * @return the phase
     */
    Phase getPhase();

    /**
     * Returns the session that is used to install the package
     * @return the session
     */
    Session getSession();

    /**
     * Returns the package that is currently installed
     * @return the vault package
     */
    VaultPackage getPackage();

    /**
     * Returns the import options that are used to install the package
     * @return the import options
     *
     * @deprecated since 2.3.12, use {@link #getOptions()} instead.
     */
    ImportOptions getImportOptions();

    /**
     * Returns the import options that are used to install the package
     * @return the import options
     */
    com.day.jcr.vault.fs.io.ImportOptions getOptions();

}