/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.packaging;

/**
 * An install hook is used to do some pre and post work during a package
 * install. the hooks need to have at least one class that implements this
 * interface. the class is identified by the normal "Main-Class" manifest
 * property and needs to be instantiatable. The instantiated hook class is
 * used for the entire life-cycle of the installation process until the
 * {@link InstallContext.Phase#END} phase.
 *
 * The hook jars need to be placed in the "META-INF/vault/hooks" directory
 * and are executed in alphabetical sequence for each installation phase.
 * A hook can throw a {@link PackageException} to abort the current phase,
 * but this has currently only an effect in the
 * {@link InstallContext.Phase#PREPARE} phase. If a hook fails, the current
 * phase is aborted and all hooks (also the failing one) are called again with
 * the respective "fail" phase.
 *
 * @deprecated since 2.5.0. Use the org.apache.jackrabbit.vault API instead.
 */
@Deprecated
public interface InstallHook {

    /**
     * Executes hook specific code. This is called for each installation
     * phase.
     *
     * @param context the installation context
     * @throws PackageException if the hook desires to abort the current phase.
     */
    void execute(InstallContext context) throws PackageException;
}