/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.packaging;

import java.io.IOException;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

/**
 * Specifies the interface of a vault package stored in the repository.
 *
 * @deprecated since 2.5.0. Use the org.apache.jackrabbit.vault API instead.
 */
@Deprecated
public interface JcrPackage extends Comparable<JcrPackage> {

    /**
     * Nodetype name of a package node
     */
    String NT_VLT_PACKAGE = "vlt:Package";

    /**
     * Nodetype name of a definition node
     */
    String NT_VLT_PACKAGE_DEFINITION = "vlt:PackageDefinition";

    /**
     * Nodename of the definition node
     */
    String NN_VLT_DEFINITION = "vlt:definition";

    /**
     * default mime type of a package
     */
    String MIME_TYPE = "application/zip";

    /**
     * Returns the package definition of this package
     * @return the package definition or <code>null</code> if this package is
     *         not valid.
     * @throws RepositoryException if an error occurrs
     */

    JcrPackageDefinition getDefinition() throws RepositoryException;

    /**
     * Checks if the underlying node contains the correct structure.
     * @return <code>true</code> if this package is valid.
     */
    boolean isValid();

    /**
     * Returns the underlying node
     * @return the node
     */
    Node getNode();

    /**
     * Checks if this package is sealed. this is the case, if it was not
     * modified since it was unwrapped.
     * @return <code>true</code> if this package is sealed.
     */
    boolean isSealed();

    /**
     * Returns the vault package stored in the data of this package
     * @return the package
     * @throws RepositoryException if an error occurs
     * @throws IOException if an I/O error occurs
     */
    VaultPackage getPackage() throws RepositoryException, IOException;

    /**
     * Extracts the package contents to the repository
     *
     * @param opts import options
     * @throws RepositoryException if a repository error during installation occurs.
     * @throws PackageException if an error during packaging occurs
     * @throws IllegalStateException if the package is not valid.
     * @throws IOException if an I/O error occurs
     * @deprecated since 2.3.14 use {@link #extract(com.day.jcr.vault.fs.io.ImportOptions)} instead.
     */
    void extract(ImportOptions opts)
            throws RepositoryException, PackageException, IOException;

    /**
     * Extracts the package contents to the repository
     *
     * @param opts import options
     * @throws RepositoryException if a repository error during installation occurs.
     * @throws PackageException if an error during packaging occurs
     * @throws IllegalStateException if the package is not valid.
     * @throws IOException if an I/O error occurs
     * @since 2.3.14
     */
    void extract(com.day.jcr.vault.fs.io.ImportOptions opts)
            throws RepositoryException, PackageException, IOException;

    /**
     * Installs the package contents to the repository but creates a snapshot if
     * necessary.
     *
     * @param opts import options
     * @throws RepositoryException if a repository error during installation occurs.
     * @throws PackageException if an error during packaging occurs
     * @throws IllegalStateException if the package is not valid.
     * @throws IOException if an I/O error occurs
     * @deprecated since 2.3.14, use {@link #install(com.day.jcr.vault.fs.io.ImportOptions)} instead
     *
     * @since 2.0
     */
    void install(ImportOptions opts)
            throws RepositoryException, PackageException, IOException;

    /**
     * Installs the package contents to the repository but creates a snapshot if
     * necessary.
     *
     * @param opts import options
     * @throws RepositoryException if a repository error during installation occurs.
     * @throws PackageException if an error during packaging occurs
     * @throws IllegalStateException if the package is not valid.
     * @throws IOException if an I/O error occurs
     *
     * @since 2.3.14
     */
    void install(com.day.jcr.vault.fs.io.ImportOptions opts)
            throws RepositoryException, PackageException, IOException;

    /**
     * Creates a snapshot of this package.
     *
     * @param opts export options
     * @param replace if <code>true</code> any existing snapshot is replaced.
     * @return a package that represents the snapshot of this package.
     * @throws RepositoryException if a repository error during installation occurs.
     * @throws PackageException if an error during packaging occurs
     * @throws IllegalStateException if the package is not valid.
     * @throws IOException if an I/O error occurs
     *
     * @since 2.0
     */
    JcrPackage snapshot(ExportOptions opts, boolean replace)
            throws RepositoryException, PackageException, IOException;

    /**
     * Returns the snapshot that was taken when installing this package.
     * @return the snapshot package or <code>null</code>
     * @throws RepositoryException if an error occurs.
     *
     * @since 2.0
     */
    JcrPackage getSnapshot() throws RepositoryException;

    /**
     * Reverts the changes of a prior installation of this package.
     *
     * @param opts import options
     * @throws RepositoryException if a repository error during installation occurs.
     * @throws PackageException if an error during packaging occurs or if no
     *         snapshot is available.
     * @throws IllegalStateException if the package is not valid.
     * @throws IOException if an I/O error occurs
     * @deprecated since 2.3.14, use {@link #uninstall(com.day.jcr.vault.fs.io.ImportOptions)} instead.
     * @since 2.0
     */
    void uninstall(ImportOptions opts)
            throws RepositoryException, PackageException, IOException;

    /**
     * Reverts the changes of a prior installation of this package.
     *
     * @param opts import options
     * @throws RepositoryException if a repository error during installation occurs.
     * @throws PackageException if an error during packaging occurs or if no
     *         snapshot is available.
     * @throws IllegalStateException if the package is not valid.
     * @throws IOException if an I/O error occurs
     *
     * @since 2.3.14
     */
    void uninstall(com.day.jcr.vault.fs.io.ImportOptions opts)
            throws RepositoryException, PackageException, IOException;

    /**
     * Checks if the package id is correct in respect to the installation path
     * and adjusts it accordingly.
     *
     * @param autoFix <code>true</code> to automatically fix the id
     * @param autoSave <code>true</code> to save changes immediately
     * @return <code>true</code> if id is correct.
     * @throws RepositoryException if an error occurs.
     *
     * @since 2.2.18
     */
    boolean verifyId(boolean autoFix, boolean autoSave) throws RepositoryException;

    /**
     * Checks if this package is installed.
     *
     * Note: the default implementation only checks the {@link com.day.jcr.vault.packaging.JcrPackageDefinition#getLastUnpacked()}
     * date. If the package is replaced since it was installed. this method will return <code>false</code>.
     *
     * @return <code>true</code> if this package is installed.
     * @throws RepositoryException if an error occurs.
     *
     * @since 2.4.6
     */
    boolean isInstalled() throws RepositoryException;

    /**
     * Returns the size of the underlying package.
     * @return the size in bytes or -1 if not valid.
     */
    long getSize();

    /**
     * Closes this package and destroys all temporary data.
     */
    void close();

    /**
     * Returns the jcr:data property of the package
     * @return the jcr:data property
     * @throws RepositoryException if an error occurrs
     */
    Property getData() throws RepositoryException;

    /**
     * Returns the definition node or <code>null</code> if not exists
     * @return the definition node.
     * @throws RepositoryException if an error occurrs
     */
    Node getDefNode() throws RepositoryException;

}