/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.packaging;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * Default access point to package managers.
 *
 * @since 2.4.0
 * @deprecated since 2.5.0. Use the org.apache.jackrabbit.vault API instead.
 */
@Deprecated
public interface Packaging {

    /**
     * Returns a non-repository based package manager.
     * @return the package manager
     */
    PackageManager getPackageManager();

    /**
     * Returns a repository based package manager.
     * @param session repository session
     * @return the package manager
     */
    JcrPackageManager getPackageManager(Session session);

    /**
     * Creates a new jcr package definition based on the given node.
     * @param defNode the node
     * @return the definition
     */
    JcrPackageDefinition createPackageDefinition(Node defNode);

    /**
     * Opens a package that is based on the given node. If <code>allowInvalid</code>
     * is <code>true</code> also invalid packages are returned, but only if the
     * node is file like (i.e. is nt:hierarchyNode and has a
     * jcr:content/jcr:data property).
     *
     * This is a shortcut version of {@link com.day.jcr.vault.packaging.JcrPackageManager#open(javax.jcr.Node, boolean)}
     * which does not create a package manager instance.
     *
     * @param node the underlying node
     * @param allowInvalid if <code>true</code> invalid packages are openend, too.
     * @return the new package or <code>null</code> it the package is not
     *         valid unless <code>allowInvalid</code> is <code>true</code>.
     * @throws javax.jcr.RepositoryException if an error occurs
     * 
     * @since 2.3.0
     */
    JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException;
}