/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.packaging;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import com.day.jcr.vault.packaging.impl.JrVltJcrPackageAdapter;
import com.day.jcr.vault.packaging.impl.JrVltJcrPackageDefinitionAdapter;
import com.day.jcr.vault.packaging.impl.JrVltJcrPackageManagerAdapter;
import com.day.jcr.vault.packaging.impl.JrVltPackageManagerAdapter;

/**
 * Default access point to package managers for non OSGi clients.
 * 
 * @since 2.0
 * @deprecated since 2.5.0. Use the org.apache.jackrabbit.vault API instead.
 */
@Deprecated
public class PackagingService {

    /**
     * Returns a non-repository based package manager.
     * @return the package manager
     */
    public static PackageManager getPackageManager() {
        return new JrVltPackageManagerAdapter(org.apache.jackrabbit.vault.packaging.PackagingService.getPackageManager());
    }

    /**
     * Returns a repository based package manager.
     * @param session repository session
     * @return the package manager
     */
    public static JcrPackageManager getPackageManager(Session session) {
        return new JrVltJcrPackageManagerAdapter(
                org.apache.jackrabbit.vault.packaging.PackagingService.getPackageManager(session)
        );
    }

    /**
     * Creates a new jcr package definition based on the given node.
     * @param defNode the node
     * @return the definition
     * @since 2.2.14
     */
    public static JcrPackageDefinition createPackageDefinition(Node defNode) {
        return JrVltJcrPackageDefinitionAdapter.create(
                org.apache.jackrabbit.vault.packaging.PackagingService.createPackageDefinition(defNode)
        );
    }

    /**
     * Opens a package that is based on the given node. If <code>allowInvalid</code>
     * is <code>true</code> also invalid packages are returned, but only if the
     * node is file like (i.e. is nt:hierarchyNode and has a
     * jcr:content/jcr:data property).
     *
     * This is a shortcut version of {@link JcrPackageManager#open(Node, boolean)}
     * which does not create a package manager instance.
     *
     * @param node the underlying node
     * @param allowInvalid if <code>true</code> invalid packages are openend, too.
     * @return the new package or <code>null</code> it the package is not
     *         valid unless <code>allowInvalid</code> is <code>true</code>.
     * @throws RepositoryException if an error occurs
     * 
     * @since 2.3.0
     */
    public static JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        return JrVltJcrPackageAdapter.create(
                org.apache.jackrabbit.vault.packaging.PackagingService.open(node, allowInvalid)
        );
    }
}