/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.util;

import java.io.IOException;
import java.io.OutputStream;

/**
 * <code>BinaryCheckOutputStream</code>...
 */
public class BinaryCheckOutputStream extends OutputStream {

    private final OutputStream out;

    private boolean binary;

    private static final boolean[] binaries = new boolean[256];
    static {
        for (int i=0; i<32; i++) {
            binaries[i] = true;
        }
        binaries['\r'] = false;
        binaries['\n'] = false;
        binaries['\t'] = false;
        binaries['\b'] = false;
        binaries['\f'] = false;
    }

    public BinaryCheckOutputStream(OutputStream out) {
        this.out = out;
    }

    public boolean isBinary() {
        return binary;
    }

    public void write(int b) throws IOException {
        if (!binary) {
            binary = binaries[b & 0xff];
        }
        out.write(b);
    }

    public void write(byte[] b) throws IOException {
        for (int i=0; i < b.length && !binary; i++) {
            binary = binaries[b[i] & 0xff];
        }
        out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i=0; i < len && !binary; i++) {
            binary = binaries[b[i+off] & 0xff];
        }
        out.write(b, off, len);
    }

    public void flush() throws IOException {
        out.flush();
    }

    public void close() throws IOException {
        out.close();
    }

}