/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.util;

import java.io.PrintWriter;

import com.day.jcr.vault.fs.api.ProgressTrackerListener;

/**
 * <code>DefaultProgressListener</code>...
*/
public class DefaultProgressListener implements ProgressTrackerListener {

    private final PrintWriter out;

    public DefaultProgressListener() {
        this(new PrintWriter(System.out));
    }

    public DefaultProgressListener(PrintWriter out) {
        this.out = out;
    }

    public void onMessage(Mode mode, String action, String path) {
        String name = path;
        if (mode == Mode.PATHS) {
            name = path.substring(path.lastIndexOf('/') + 1);
        }
        out.printf("%s %s%n", action, name);
        out.flush();
    }

    public void onError(Mode mode, String path, Exception e) {
        String name = path;
        if (mode == Mode.PATHS) {
            name = path.substring(path.lastIndexOf('/') + 1);
        }
        out.printf("E %s (%s)%n", name, e.toString());
        out.flush();
    }

}