/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.util;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

/**
 * Helper class that represents a (jcr) property in the document view format.
 * It contains formatting and parsing methods for writing/reading enhanced
 * docview properties.
 *
 * <code>prop:= [ "{" type "}" ] ( value | "[" [ value { "," value } ] "]" )</code>
 */
public class DocViewProperty {

    private final org.apache.jackrabbit.vault.util.DocViewProperty p;

    public DocViewProperty(org.apache.jackrabbit.vault.util.DocViewProperty p) {
        this.p = p;
    }

    /**
     * Creates a new property.
     * @param name name of the property
     * @param values values.
     * @param multi multiple flag
     * @param type type of the property
     * @throws IllegalArgumentException if single value property and not
     *         exactly 1 value is given.
     */
    public DocViewProperty(String name, String[] values, boolean multi, int type) {
        p = new org.apache.jackrabbit.vault.util.DocViewProperty(name, values, multi, type);
    }

    /**
     * Parses a enhanced docview property string and returns the property.
     * @param name name of the property
     * @param value (attribute) value
     * @return a property
     */
    public static DocViewProperty parse(String name, String value) {
        return new DocViewProperty(org.apache.jackrabbit.vault.util.DocViewProperty.parse(name, value));
    }

    /**
     * Formats the given jcr property to the enhanced docview syntax.
     * @param prop the jcr property
     * @return the formatted string
     * @throws RepositoryException if a repository error occurs
     */
    public static String format(Property prop) throws RepositoryException {
        return format(prop, false);
    }
    
    /**
     * Formats the given jcr property to the enhanced docview syntax.
     * @param prop the jcr property
     * @param sort if <code>true</code> multivalue properties are sorted
     * @return the formatted string
     * @throws RepositoryException if a repository error occurs
     */
    public static String format(Property prop, boolean sort)
            throws RepositoryException {
        return org.apache.jackrabbit.vault.util.DocViewProperty.format(prop, sort);
    }

    /**
     * Checks if the type of the given property is ambiguous in respect to it's
     * property definition. the current implementation just checks some well
     * known properties.
     *
     * @param prop the property
     * @return type
     * @throws RepositoryException if a repository error occurs
     */
    public static boolean isAmbiguous(Property prop) throws RepositoryException {
        return org.apache.jackrabbit.vault.util.DocViewProperty.isAmbiguous(prop);
    }

    /**
     * Sets this property on the given node
     *
     * @param node the node
     * @return <code>true</code> if the value was modified.
     * @throws RepositoryException if a repository error occurs
     */
    public boolean apply(Node node) throws RepositoryException {
        return p.apply(node);
   }
}