/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.util;

import java.io.IOException;
import java.io.Writer;

import com.day.jcr.vault.fs.api.ProgressTrackerListener;

/**
 * <code>HtmlProgrressTrackerListener</code>...
 *
 */
public class HtmlProgressListener implements ProgressTrackerListener {

    private final Writer out;

    private boolean noScrollTo;

    private long scrollDelay = 1000;

    private long lastScrolled = 0;

    public HtmlProgressListener(Writer out) {
        this.out = out;
    }

    public boolean isNoScrollTo() {
        return noScrollTo;
    }

    public HtmlProgressListener setNoScrollTo(boolean noScrollTo) {
        this.noScrollTo = noScrollTo;
        return this;
    }

    public long getScrollDelay() {
        return scrollDelay;
    }

    public HtmlProgressListener setScrollDelay(long scrollDelay) {
        this.scrollDelay = scrollDelay;
        return this;
    }

    public void onError(Mode mode, String path, Exception e) {
        print(mode, "E", path, e.toString());
    }

    public void onMessage(Mode mode, String action, String path) {
        print(mode, action, path, null);
    }

    private void print(Mode mode, String action, String path, String msg) {
        try {
            out.write("<span class=\"");
            out.write(action);
            out.write("\">");
            out.write("<b>");
            out.write(action);
            out.write("</b>&nbsp;");
            out.write(path);
            if (msg != null) {
                out.write(" (");
                out.write(msg);
                out.write(")");
            }
            out.write("</span><br>\r\n");
            if (!noScrollTo) {
                long now = System.currentTimeMillis();
                if (now > lastScrolled + scrollDelay) {
                    lastScrolled = now;
                    out.write("<script>\r\n");
                    out.write("window.scrollTo(0, 1000000);\r\n");
                    out.write("</script>\r\n");
                }
            }
            out.flush();
        } catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

}