/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.util;

import java.util.Comparator;

import javax.jcr.Item;
import javax.jcr.RepositoryException;

/**
 * <code>ItemNameComparator</code>...
 */
public class ItemNameComparator implements Comparator<Item> {

    public static final ItemNameComparator INSTANCE = new ItemNameComparator();

    public int compare(Item o1, Item o2) {
        try {
            // sort namespaced first
            String n1 = o1.getName().toLowerCase();
            String n2 = o2.getName().toLowerCase();
            int i1 = n1.indexOf(':');
            int i2 = n2.indexOf(':');
            if (i1 >=0 && i2 < 0) {
                return -1;
            } else if (i1 < 0 && i2 >=0) {
                return 1;
            } else {
                return n1.compareTo(n2);
            }
        } catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }
}