/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.util;

import java.util.Comparator;

/**
 * <code>PathComparator</code>...
 *
 */
public class PathComparator implements Comparator<String> {

    private final char separator;

    private boolean reverse;

    public PathComparator() {
        separator = '/';
    }

    public PathComparator(boolean reverse) {
        separator = '/';
        this.reverse = reverse;
    }

    public PathComparator(char separator) {
        this.separator = separator;
    }

    public PathComparator(char separator, boolean reverse) {
        this.separator = separator;
        this.reverse = reverse;
    }

    /**
     * {@inheritDoc}
     *
     * Compared to the {@link String#compareTo(String)} it handles the '/'
     * differently giving it the highest priority so that:
     *
     * "/a" < "/b"
     * "/a1foo" < "/a/foo"
     */
    public int compare(String o1, String o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        int last0 = 0;
        int last1 = 0;
        int i0 = o1.indexOf(separator, 1);
        int i1 = o2.indexOf(separator, 1);
        while (i0 > 0 && i1 > 0) {
            int c = o1.substring(last0, i0).compareTo(o2.substring(last1, i1));
            if (c != 0) {
                return reverse ? -c : c;
            }
            last0 = i0;
            last1 = i1;
            i0 = o1.indexOf(separator, i0 + 1);
            i1 = o2.indexOf(separator, i1 + 1);
        }
        int ret;
        if (i0 > 0) {
            ret = 1;
        } else if (i1 > 0) {
            ret = -1;
        } else {
            // compare last segment
            ret = o1.substring(last0).compareTo(o2.substring(last1));
        }
        return reverse ? -ret : ret;
    }
}