/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.util;

import java.io.IOException;
import java.io.StringReader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Entity resolver that handles all entity resolution requests by returning an empty input source.
 * This is to prevent "Arbitrary DTD inclusion in XML parsing".
 */
public class RejectingEntityResolver implements EntityResolver {

    /**
     * default logger
     */
    private static final Logger log = LoggerFactory.getLogger(RejectingEntityResolver.class);

    public InputSource resolveEntity(String publicId, String systemId)
            throws SAXException, IOException {
        log.warn("Rejecting external entity loading with publicId={} systemId={}", publicId, systemId);
        return new InputSource(new StringReader(""));
    }

}