/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * <code>TempFileInputStream</code>...
 */
public class TempFileInputStream extends FileInputStream {

    private File file;

    public TempFileInputStream(String name) throws FileNotFoundException {
        this(new File(name));
    }

    public TempFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.file = file;
    }

    public TempFileInputStream(FileDescriptor fdObj) {
        super(fdObj);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (file != null) {
            file.delete();
        }
    }
}