/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/

package com.day.jcr.vault.util;

import java.util.Comparator;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

/**
 * Comparator for values
 */
public class ValueComparator implements Comparator<Value> {

    private static final ValueComparator INSTANCE = new ValueComparator();

    private ValueComparator() {
    }

    public static ValueComparator getInstance() {
        return INSTANCE;
    }

    public int compare(Value o1, Value o2) {
        try {
            // assume types are equal
            switch (o1.getType()) {
                case PropertyType.BINARY:
                    throw new IllegalArgumentException("sorting of binary values not supported.");
                case PropertyType.DATE:
                    return o1.getDate().compareTo(o2.getDate());
                case PropertyType.DECIMAL:
                    return o1.getDecimal().compareTo(o2.getDecimal());
                case PropertyType.DOUBLE:
                    return ((Double) o1.getDouble()).compareTo(o2.getDouble());
                case PropertyType.LONG:
                    return ((Long) o1.getLong()).compareTo(o2.getLong());
                default:
                    return o1.getString().compareTo(o2.getString());
            }
        } catch (RepositoryException e) {
            throw new IllegalArgumentException(e);
        }
    }
}