/**
 * $Id: EnumerationIterator.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * The <code>EnumerationIterator</code> implements an <code>Iterator</code> that
 * iterates over a given <code>Enumeration</code>. This is usefull, when needing
 * an <code>Iterator</code> but having an <code>Enumeration</code>.
 *
 * @version $Revision: 1.7 $
 * @author tripod
 * @since antbear
 * @audience wad
 */
public class EnumerationIterator implements Iterator {

    /** the internal enumeratrion */
    private final Enumeration delegatee;

    /**
     * Constructs an <code>EnuerationIterator</code>
     * @param delegatee the underlaying enumeration
     */
    public EnumerationIterator(Enumeration delegatee) {
        this.delegatee = delegatee;
    }

    /**
     * @see Iterator#hasNext()
     */
    public boolean hasNext() {
        return delegatee.hasMoreElements();
    }

    /**
     * @see Iterator#next()
     */
    public Object next() {
        return delegatee.nextElement();
    }

    /**
     * Always throws <code>UnsupportedOperationException</code>.
     *
     * @see Iterator#remove()
     */
    public void remove() {
        throw new UnsupportedOperationException();
    }
}
