/*
 * $Id: ExecutionContext.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util;

import java.io.File;

/**
 * An <code>ExecutionContext</code> contains temporary objects. When the
 * context is destroyed, its attached temporary objects are destroyed.
 *
 * @audience dev
 * @version $Revision: 1.5 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author dpfister
 * @since antbear
 */
public interface ExecutionContext {

    /**
     * Add a generic temporary object that implements the {@link Finalizer}
     * interface. Its {@link Finalizer#doFinalize()} method will be called
     * when the <code>ExecutionContext</code> is destroyed.
     */
    public void registerObject(Finalizer object);

    /**
     * Add a temporary file to this <code>ExecutionContext</code>. The
     * temporary file will be deleted when the context is destroyed.
     * @param file file to remember
     */
    public void addTempFile(File file);
}
