/*
 * $Id: Finalizer.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util;


/**
 * Object who need to be cleaned up when an <code>ExecutionContext</code>
 * is destroyed, the <code>Finalizer</code> interface may register with the
 * {@link com.day.cq.util.FinalizerHandler}. At the end of the
 * <code>ExecutionContext</code>, all registered <code>Finalizer</code>
 * instances are called for their cleanup work.
 *
 * @version $Revision: 1.9 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author fmeschbe
 * @since antbear
 */
public interface Finalizer {

    /**
     * This is the method called by the {@link com.day.cq.util.FinalizerHandler}
     * when the finalizing work has to be done.
     */
    public void doFinalize();

}