/*
 * $Id: HandleExpander.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util;

/**
 * A <code>HandleExpander</code> is used to expand a globbing pattern to a list
 * of handles, that match the given pattern. This 'expansiion' is done
 * unix-shell-like. for example the pattern <xmp>/site/*</xmp> could be expanded
 * to <xmp>/site/en, /site/fr</xmp>.
 *
 * @version $Revision: 1.9 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author tripod
 * @since antbear
 * @audience dev
 */
public interface HandleExpander {

    /**
     * Expand the handles to the given pattern.
     * @param pattern the pattern to match.
     * @return an array of handles that are expanded from the pattern
     */
    public String[] expand(String pattern);
}