/*
 * $Id: IteratorEnumeration.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * An <code>IteratorEnumeration</code> provides a one-to-one mapping
 * from the pre Java 2 {@link java.util.Enumeration} to the Java 2
 * {@link java.util.Iterator}
 *
 * @version $Revision: 1.4 $
 * @author dpfister
 * @since antbear
 */
public class IteratorEnumeration implements Enumeration {

    /** Underlying iterator */
    protected Iterator iter;

    /**
     * Create a new <code>IteratorEnumeration</code> given an
     * {@link java.util.Iterator} that backs up the
     * {@link java.util.Enumeration}
     */
    public IteratorEnumeration(Iterator iter) {
	this.iter = iter;
    }

    /**
     * Tests if this enumeration contains more elements.
     *
     * @return  <code>true</code> if and only if this enumeration object
     *           contains at least one more element to provide;
     *          <code>false</code> otherwise.
     */
    public boolean hasMoreElements() {
	return iter.hasNext();
    }

    /**
     * Returns the next element of this enumeration if this enumeration
     * object has at least one more element to provide.
     *
     * @return     the next element of this enumeration.
     * @exception  NoSuchElementException  if no more elements exist.
     */
    public Object nextElement() {
	return iter.next();
    }
}
