/** 
 * $Id: ListMap.java 12345 2004-08-22 04:56:09Z fielding $ 
 * 
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland 
 * All Rights Reserved. 
 * 
 * This software is the confidential and proprietary information of 
 * Day Management AG, ("Confidential Information"). You shall not 
 * disclose such Confidential Information and shall use it only in 
 * accordance with the terms of the license agreement you entered into 
 * with Day. 
 */

package com.day.util;

import java.util.*;

/**
 * Simple implementation of a List which has elements also retreivable by a key.
 *
 * @version $Revision: 1.7 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $ 
 * @author benp
 * @since antbear
 * @audience core
 */
public class ListMap {

    private List list = null;   // List of Entrys {key, value}
    private Map  map  = null;      // Map  of key -> value  where key, value are a pair in the list.

    public ListMap() {
	list = new LinkedList();  // Good for iterating
	map  = new HashMap();     // Good for lookups
    }
    public ListMap(int size) {
	list = new LinkedList();
	map  = new HashMap(size);
    }

    public int size() {
	return list.size();
    }

    public Iterator iterator() {
	return list.iterator();
    }

    public int put(Object key, Object value) {
	if (map.get(key) != null) {
	    throw new java.lang.IllegalArgumentException("Key '" + key + "' already exists in the ListMap.");
	}
	map.put(key, value);
	list.add(new Entry(key, value));
	return list.size() - 1;
    }

    public Object get(Object key) {
	return map.get(key);
    }

    public Entry get(int index) {
	return (Entry)list.get(index);
    }

    public boolean isEmpty() {
	return list.isEmpty();
    }

    public void clear() {
	list.clear();
	map.clear();
    }

    public String toString() {

	String buf = "";
	for (Iterator listIf = list.iterator(); listIf.hasNext();) {
	    Entry entry = (Entry) listIf.next();

	    if (entry.val instanceof ListMap) {
		buf += "" + entry.key + "= (ListMap):\n" + ((ListMap)(entry.val)).toString(1);
	    }
	    else {
		buf += "" + entry.key + "=" + entry.getValue() + "\n";
	    }
	}

	return buf;
    }

    private String toString(int indent) {
	String buf = "";

	String white = "";
	for (int i=0; i<indent; i++) {
	    white += "  ";
	}

	for (Iterator listIf = list.iterator(); listIf.hasNext();) {
	    Entry entry = (Entry) listIf.next();

	    if (entry.val instanceof ListMap) {
		buf += white + entry.key + "=\n" + ((ListMap)(entry.val)).toString(indent + 1);
	    }
	    else {
		buf += white + entry.key + "=" + entry.val + "\n";
	    }
	}
	return buf;
    }

    public Entry getLast() {
	if (list.size() == 0) { return null; }
	return (Entry)list.get(list.size()-1);
    }

    public class Entry {
	public Entry(Object key, Object val) {
	    this.key = key;
	    this.val = val;
	}
	private Object key = null;
	private Object val = null;
	public Object getKey() { return key; }
	public Object getValue() { return val; }
    }
}