/**
 * $Id: Math.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util;

/**
 * This class provides some mathematical utilities that extends those of
 * {@link java.lang.Math}.
 *
 * @version $Revision: 1.7 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author fmeschbe
 * @since antbear
 * @audience wad
 */

public final class Math {

    private Math() {
    }

    /**
     * Returns the smallest of the three argument values.
     *
     * @param a The first value
     * @param b The second value
     * @param c The third value
     *
     * @return The smallest value of the three
     */
    public static final int min3(int a, int b, int c) {
	return (a<b ? (a<c ? a : c ) : (b<c ? b : c));
    }

    /**
     * Returns the largest of the three argument values.
     *
     * @param a The first value
     * @param b The second value
     * @param c The third value
     *
     * @return The largest value of the three
     */
    public static final int max3(int a, int b, int c) {
	return (a>b ? (a>c ? a : c ) : (b>c ? b : c));
    }

    /**
     * Returns the smallest of the three argument values.
     *
     * @param a The first value
     * @param b The second value
     * @param c The third value
     *
     * @return The smallest value of the three
     */
    public static final double min3(double a, double b, double c) {
	return (a<b ? (a<c ? a : c ) : (b<c ? b : c));
    }

    /**
     * Returns the largest of the three argument values.
     *
     * @param a The first value
     * @param b The second value
     * @param c The third value
     *
     * @return The largest value of the three
     */
    public static final double max3(double a, double b, double c) {
	return (a>b ? (a>c ? a : c ) : (b>c ? b : c));
    }

}