/*
 * $Id: NameValuePair.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util;

/**
 * The NameValuePair class implements a structure of a name and an optional
 * value.
 *
 * @version $Revision: 1.4 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author tripod
 * @since coati
 * @audience wad
 */
public class NameValuePair {

    /** the name */
    private final String name;

    /** the value */
    private final String value;

    /**
     * Creates a new name value pair
     */
    public NameValuePair(String name, String value) {
	this.name = name;
	this.value = value;
    }

    /**
     * Gets the name
     */
    public String getName() {
	return name;
    }

    /**
     * Gets the value
     */
    public String getValue() {
	return value;
    }

    /**
     * Parses a line of the form:
     * {ws} name {ws} ["=" {ws} value {ws}];
     *
     * @param str the string to parse
     */
    public static NameValuePair parse(String str) {
	return parse(str, '=');
    }

    /**
     * Parses a line of the form:
     * {ws} name {ws} ["<code>&lt;equal&gt;</code>" {ws} value {ws}];
     *
     * @param str the string to parse
     * @param equal the delimiter for the equal sign
     */
    public static NameValuePair parse(String str, char equal) {

	int state=0;
	int lastState=0;
	int nameStart=0;
	int nameEnd=0;
	StringBuffer value = new StringBuffer();
	for (int i=0; i<str.length(); i++) {
	    char c=str.charAt(i);
	    switch (state) {
		case 0: // before name
		    if (!Character.isWhitespace(c)) {
			nameStart=i;
			state=1;
		    }
		    break;
		case 1: // reading name
		    if (c==equal) {
			nameEnd=i;
			state=3;
		    } else if (Character.isWhitespace(c)) {
			nameEnd=i;
			state=2;
		    }
		    break;
		case 2: // after name
		    if (c==equal) {
			state=3;
		    }
		    break;
		case 3: // after equal
		    if (c=='\"') {
			state=4;
		    } else if (c=='\'') {
			state=5;
		    } else if (!Character.isWhitespace(c)) {
			value.append(c);
			state=6;
		    }
		    break;
		case 4: // double quote
		    if (c=='\"') {
			state=6;
		    } else if (c=='\\') {
			lastState=state;
			state=7;
		    } else {
			value.append(c);
		    }
		    break;
		case 5: // single quote
		    if (c=='\'') {
			state=6;
		    } else if (c=='\\') {
			lastState=state;
			state=7;
		    } else {
			value.append(c);
		    }
		    break;
		case 6: // value
		    if (c=='\'') {
			state=5;
		    } else if (c=='\"') {
			state=4;
		    } else if (c=='\\') {
			lastState=state;
			state=7;
		    } else if (!Character.isWhitespace(c)) {
			value.append(c);
		    }
		    break;
		case 7: // escape
		    value.append(c);
		    state=lastState;
		    break;
	    }
	}
	// if name never finished
	if (nameEnd==0) {
	    return new NameValuePair(str.substring(nameStart), "");
	} else {
	    return new NameValuePair(str.substring(nameStart, nameEnd), value.toString());
	}
    }
}
