/*
 * $Id: OrderedSet.java 12342 2004-08-22 00:22:22Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/**
 * Helper class that implements a set, but preserves the order of inserting
 * the elements when accessing an iterator.
 *
 * @version $Revision: 1.3 $, $Date: 2004-08-22 02:22:22 +0200 (Sun, 22 Aug 2004) $
 * @author tripod
 * @since coati, moved to com.day.util for iguana
 * @audience core
 */
public class OrderedSet implements Set {

    /** the internal map */
    private final HashSet set;

    /** the list of the order */
    private final LinkedList list = new LinkedList();

    /**
     * Constructs a new, empty set; the backing <tt>HashMap</tt> instance has
     * default initial capacity (16) and load factor (0.75).
     */
    public OrderedSet() {
        set = new HashSet();
    }

    /**
     * Constructs a new set containing the elements in the specified collection.
     * The <tt>Set</tt> is created with default load factor (0.75) and an
     * initial capacity sufficient to contain the elements in the specified
     * collection.
     *
     * @param c the collection whose elements are to be placed into this set.
     * @throws NullPointerException if the specified collection is null.
     */
    public OrderedSet(Collection c) {
        set = new HashSet(java.lang.Math.max((int) (c.size() / .75f) + 1, 16));
        addAll(c);
    }

    /**
     * Constructs a new, empty set; the backing <tt>Set</tt> instance has
     * the specified initial capacity and the specified load factor.
     *
     * @param initialCapacity the initial capacity of the hash map.
     * @param loadFactor the load factor of the hash map.
     * @throws IllegalArgumentException if the initial capacity is less than
     *             zero, or if the load factor is nonpositive.
     */
    public OrderedSet(int initialCapacity, float loadFactor) {
        set = new HashSet(initialCapacity, loadFactor);
    }

    /**
     * Constructs a new, empty set; the backing <tt>Set</tt> instance has
     * the specified initial capacity and default load factor, which is
     * <tt>0.75</tt>.
     *
     * @param initialCapacity the initial capacity of the hash table.
     * @throws IllegalArgumentException if the initial capacity is less than
     *             zero.
     */
    public OrderedSet(int initialCapacity) {
        set = new HashSet(initialCapacity);
    }

    public int size() {
	return set.size();
    }

    public boolean isEmpty() {
	return set.isEmpty();
    }

    public boolean contains(Object o) {
	return set.contains(o);
    }

    public Iterator iterator() {
	return list.iterator();
    }

    public Object[] toArray() {
	return list.toArray();
    }

    public Object[] toArray(Object a[]) {
	return list.toArray(a);
    }

    public boolean add(Object o) {
	if (set.add(o)) {
	    list.add(o);
	    return true;
	} else {
	    return false;
	}
    }

    public boolean remove(Object o) {
	if (set.remove(o)) {
	    list.remove(o);
	    return true;
	} else {
	    return false;
	}
    }

    public boolean containsAll(Collection c) {
	return set.containsAll(c);
    }

    public boolean addAll(Collection c) {
	boolean ret=false;
	Iterator iter = c.iterator();
	while (iter.hasNext()) {
	    ret |= add(iter.next());
	}
	return ret;
    }

    public boolean retainAll(Collection c) {
	// not quite correct :-)
	set.clear();
	list.clear();
	return addAll(c);
    }

    public boolean removeAll(Collection c) {
	boolean ret=false;
	Iterator iter = c.iterator();
	while (iter.hasNext()) {
	    ret |= remove(iter.next());
	}
	return ret;
    }

    public void clear() {
	set.clear();
	list.clear();
    }
}
